<?php

#	Konfigurationsdatei für MySQL-Datenbankverbindung und LDAP-Anbindung
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 18.01.2025

# Allgemeine-Konfiguration
$app_config = [
    'maintenance_mode' => false,
    'timezone' => 'Asia/Amman',
    'map_tile' => 'https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}',
    'map_position' => '31.834574489925796, 36.76292857332484',
];

# MySQL-Datenbankkonfiguration
$mysql_config = [
    'host' => 'localhost',      // MySQL Server-Hostname oder IP-Adresse
    'username' => 'campguard',        // MySQL Benutzername
    'password' => '',    // MySQL Passwort
    'database' => 'campguard',        // Name der MySQL-Datenbank
    'port' => 3306,             // MySQL Port (Standard: 3306)
    'charset' => 'utf8mb4'         // Zeichensatz für die Verbindung (optional)
];

# LDAP-Konfiguration
$ldap_config = [
    'host' => 'ldap://localhost', // LDAP Server-Hostname oder IP-Adresse
    'port' => 389,                // LDAP Port (Standard: 389 für unverschlüsselte Verbindung, 636 für LDAPS)
    'bind_dn' => 'gefstdlwmcd\ldap', // Bind-DN für die Authentifizierung
    'bind_pass' => '',    // Passwort für die Authentifizierung
    'base_dn' => 'ou=users,dc=gefstdlwmcd,dc=de', // Basis-DN für Suchanfragen
    'required_group' => 'CN=CampGuard_Nutzer,ou=groups,dc=gefstdlwmcd,dc=de'       // Suchfilter, %s wird durch den Benutzernamen ersetzt
];

?>